<?php
/**
 * License resolver placeholder.
 *
 * Policy: never block install/upgrade from completing.
 * License enforcement should be handled in runtime (service layer),
 * not by breaking package installation.
 */

declare(strict_types=1);

use MODX\Revolution\modX;
use xPDO\Transport\xPDOTransport;

if (!isset($transport) || !is_object($transport)) {
    return true;
}

/** @var modX $modx */
$modx = $transport->xpdo;

$action = $options[xPDOTransport::PACKAGE_ACTION] ?? null;

if (!in_array($action, [xPDOTransport::ACTION_INSTALL, xPDOTransport::ACTION_UPGRADE], true)) {
    return true;
}

$modx->log(modX::LOG_LEVEL_INFO, '[i18n] License resolver: executed (action=' . (string)$action . ')');

// Optional: set a known state only on install, without overwriting existing state.
if ((int)$action === xPDOTransport::ACTION_INSTALL) {
    try {
        $key = 'i18n.license_state';

        $setting = $modx->getObject(\MODX\Revolution\modSystemSetting::class, ['key' => $key]);
        if ($setting && (string)$setting->get('value') === '') {
            $setting->set('value', 'unlicensed');
            $setting->save();
            $modx->log(modX::LOG_LEVEL_INFO, '[i18n] License resolver: initialized license_state=unlicensed');
        }
    } catch (\Throwable $e) {
        $modx->log(modX::LOG_LEVEL_ERROR, '[i18n] License resolver: exception: ' . $e->getMessage());
        // Do not fail install
    }
}

return true;
