<?php
/**
 * Ultra-safe transport resolver ping (MODX 3 compatible).
 * - Writes core/cache/i18n_resolver_ping.txt
 * - Creates/updates system setting i18n._resolver_ping
 */

if (!isset($modx) || !is_object($modx)) {
    return true;
}

try {
    $corePath = (string)$modx->getOption('core_path');
    $file = rtrim($corePath, '/\\') . DIRECTORY_SEPARATOR . 'cache' . DIRECTORY_SEPARATOR . 'i18n_resolver_ping.txt';

    @file_put_contents($file, date('c') . " ping\n", FILE_APPEND);

    // Use string class names (most compatible across MODX builds)
    $key = 'i18n._resolver_ping';

    $s = $modx->getObject('modSystemSetting', ['key' => $key]);
    if (!$s) {
        $s = $modx->newObject('modSystemSetting');
        $s->fromArray([
            'key'       => $key,
            'namespace' => 'i18n',
            'area'      => 'build',
            'xtype'     => 'textfield',
        ], '', true, true);
    }

    $s->set('value', date('c') . ' OK');
    $s->save();

    $modx->log(modX::LOG_LEVEL_ERROR, '[i18n] resolver ping executed (setting + file written)');
} catch (Throwable $e) {
    // If Throwable is not available (older), catch Exception as fallback
    try {
        $modx->log(modX::LOG_LEVEL_ERROR, '[i18n] resolver ping exception: ' . $e->getMessage());
    } catch (Exception $ex) {}
} catch (Exception $e) {
    try {
        $modx->log(modX::LOG_LEVEL_ERROR, '[i18n] resolver ping exception: ' . $e->getMessage());
    } catch (Exception $ex) {}
}

return true;
