<?php
/**
 * Create DB tables for i18n package (MODX3/xPDO3).
 */

use MODX\Revolution\modX;
use xPDO\Transport\xPDOTransport;

if (!isset($modx) || !($modx instanceof modX)) {
    return true;
}

$action = (int)($options[xPDOTransport::PACKAGE_ACTION] ?? 0);
$modx->log(modX::LOG_LEVEL_INFO, '[i18n] resolve.tables start, action=' . $action);

if (!in_array($action, [xPDOTransport::ACTION_INSTALL, xPDOTransport::ACTION_UPGRADE], true)) {
    $modx->log(modX::LOG_LEVEL_INFO, '[i18n] resolve.tables skipped (not install/upgrade)');
    return true;
}

$corePath  = rtrim((string)$modx->getOption('core_path'), '/\\') . DIRECTORY_SEPARATOR . 'components' . DIRECTORY_SEPARATOR . 'i18n' . DIRECTORY_SEPARATOR;
$modelPath = $corePath . 'model' . DIRECTORY_SEPARATOR;

$meta = $modelPath . 'i18n' . DIRECTORY_SEPARATOR . 'metadata.mysql.php';
$modx->log(modX::LOG_LEVEL_INFO, '[i18n] modelPath=' . $modelPath);
$modx->log(modX::LOG_LEVEL_INFO, '[i18n] metadata=' . $meta);

if (!is_dir($modelPath)) {
    $modx->log(modX::LOG_LEVEL_ERROR, '[i18n] Model dir missing: ' . $modelPath);
    return true;
}
if (!file_exists($meta)) {
    $modx->log(modX::LOG_LEVEL_ERROR, '[i18n] metadata.mysql.php missing: ' . $meta);
    return true;
}

// Register package
$tablePrefix = (string)$modx->getOption('table_prefix', null, 'modx_');
$modx->log(modX::LOG_LEVEL_INFO, '[i18n] table_prefix=' . $tablePrefix);

try {
    $modx->addPackage('i18n', $modelPath, $tablePrefix);
} catch (Throwable $e) {
    $modx->log(modX::LOG_LEVEL_ERROR, '[i18n] addPackage failed: ' . $e->getMessage());
    return true;
}

$manager = $modx->getManager();
if (!$manager) {
    $modx->log(modX::LOG_LEVEL_ERROR, '[i18n] Could not get manager');
    return true;
}

$classes = [
    'i18n\\I18nKey',
    'i18n\\I18nValue',
    'i18n\\I18nUsage',
];

foreach ($classes as $class) {
    try {
        $exists = (bool)$manager->tableExists($class);
        $modx->log(modX::LOG_LEVEL_INFO, '[i18n] tableExists ' . $class . '=' . ($exists ? 'yes' : 'no'));

        if ($exists) {
            continue;
        }

        $ok = (bool)$manager->createObjectContainer($class);
        if ($ok) {
            $modx->log(modX::LOG_LEVEL_INFO, '[i18n] createObjectContainer OK: ' . $class);
        } else {
            $modx->log(modX::LOG_LEVEL_ERROR, '[i18n] createObjectContainer FAIL: ' . $class);
            // Try to dump last error if driver provides it
            $err = $modx->error ? $modx->error->message : '';
            if ($err) {
                $modx->log(modX::LOG_LEVEL_ERROR, '[i18n] last error: ' . $err);
            }
        }
    } catch (Throwable $e) {
        $modx->log(modX::LOG_LEVEL_ERROR, '[i18n] Exception for ' . $class . ': ' . $e->getMessage());
    }
}

$modx->log(modX::LOG_LEVEL_INFO, '[i18n] resolve.tables done');
return true;
