<?php
declare(strict_types=1);

use MODX\Revolution\modX;

/**
 * Read element file content with strict error handling.
 */
function i18n_read_element_file(modX $modx, string $path): string
{
    if (!is_file($path)) {
        $modx->log(modX::LOG_LEVEL_ERROR, '[i18n] Build: element file not found: ' . $path);
        return '';
    }

    $content = file_get_contents($path);
    if ($content === false) {
        $modx->log(modX::LOG_LEVEL_ERROR, '[i18n] Build: cannot read element file: ' . $path);
        return '';
    }

    return $content;
}
