<?php
declare(strict_types=1);

use MODX\Revolution\modX;
use xPDO\Transport\xPDOTransport;

if (!isset($transport) || !is_object($transport)) {
    return true;
}

/** @var modX $modx */
$modx = $transport->xpdo;

$action = $options[xPDOTransport::PACKAGE_ACTION] ?? null;
if (!in_array($action, [xPDOTransport::ACTION_INSTALL, xPDOTransport::ACTION_UPGRADE], true)) {
    return true;
}

$componentRoot = MODX_CORE_PATH . 'components/i18n/';

// Folders safe to remove in production installs
$remove = [
    $componentRoot . '_build',
];

$rmDir = static function (string $dir) use (&$rmDir): void {
    if (!is_dir($dir)) return;
    $items = scandir($dir);
    if ($items === false) return;
    foreach ($items as $item) {
        if ($item === '.' || $item === '..') continue;
        $path = $dir . DIRECTORY_SEPARATOR . $item;
        if (is_dir($path)) $rmDir($path);
        else @unlink($path);
    }
    @rmdir($dir);
};

foreach ($remove as $dir) {
    if (is_dir($dir)) {
        $rmDir($dir);
        $modx->log(modX::LOG_LEVEL_INFO, '[i18n] Cleanup resolver: removed ' . $dir);
    }
}

return true;
