<?php
/**
 * Sanity resolver: proves resolver chain is executed and logging works.
 * Must never break installation.
 */

declare(strict_types=1);

use MODX\Revolution\modX;
use xPDO\Transport\xPDOTransport;

if (!isset($transport) || !is_object($transport)) {
    return true;
}

/** @var modX $modx */
$modx = $transport->xpdo;

$action = $options[xPDOTransport::PACKAGE_ACTION] ?? null;

$modx->log(modX::LOG_LEVEL_INFO, '[i18n] Resolver ping: executed (action=' . (string)$action . ')');

return true;
