<?php

/**
 * Simple PSR-4 autoloader for the I18n component.
 */

if (!class_exists(\I18n\Service\I18n::class)) {
    spl_autoload_register(function ($class) {
        $prefix   = 'I18n\\';
        $baseDir  = MODX_CORE_PATH . 'components/i18n/src/';

        $len = strlen($prefix);
        if (strncmp($class, $prefix, $len) !== 0) {
            return;
        }

        $relative = substr($class, $len);
        $file     = $baseDir . str_replace('\\', '/', $relative) . '.php';

        if (file_exists($file)) {
            require $file;
        }
    });
}
