<?php
// core/components/i18n/config/i18n.php

return [
    // Fallback default language (overridden by system setting i18n.default_lang)
    'default' => 'en',

    // Fallback languages list (overridden by system setting i18n.allowed_langs)
    'languages' => ['en'],
	
	// Fallback default group (overridden by system setting i18n.default_prefix)
    'default_prefix' => 'manual',
	
	// Manager UI defaults
	'mgr_tools_enabled' => true,

    /**
     * Aliases for language normalization.
     *
     * Keys are LOWERCASE; LangMapper lowercases input before lookup.
     * These only help if target language is actually allowed / configured.
     */
	'aliases' => [
		// English
		'eng'      => 'en',
		'english'  => 'en',
		'en_us'    => 'en',
		'en-gb'    => 'en',
		'en_gb'    => 'en',
		'en-uk'    => 'en',
		'en_uk'    => 'en',

		// Russian
		'rus'      => 'ru',
		'russian'  => 'ru',
		'ru_ru'    => 'ru',

		// Ukrainian
		'ua'        => 'uk',
		'ukr'       => 'uk',
		'uk_ua'     => 'uk',
		'ukrainian' => 'uk',

		// Polish
		'pol'      => 'pl',
		'polish'   => 'pl',
		'pl_pl'    => 'pl',

		// German
		'ger'      => 'de',
		'deu'      => 'de',
		'german'   => 'de',
		'de_de'    => 'de',

		// Spanish
		'spa'      => 'es',
		'spanish'  => 'es',
		'es_es'    => 'es',

		// French
		'fre'      => 'fr',
		'fra'      => 'fr',
		'french'   => 'fr',
		'fr_fr'    => 'fr',

		// Portuguese
		'por'        => 'pt',
		'portuguese' => 'pt',
		'pt_br'      => 'pt',
		'pt_pt'      => 'pt',

		// Italian
		'ita'      => 'it',
		'italian'  => 'it',
		'it_it'    => 'it',

		// Chinese
		'chi'      => 'zh',
		'zho'      => 'zh',
		'chinese'  => 'zh',
		'zh_cn'    => 'zh',
		'zh_tw'    => 'zh',

		// Czech
		'ces'      => 'cs',
		'cze'      => 'cs',
		'czech'    => 'cs',
		'cs_cz'    => 'cs',

		// Slovak
		'slk'      => 'sk',
		'slo'      => 'sk',
		'slovak'   => 'sk',
		'sk_sk'    => 'sk',

		// Serbian
		'srp'      => 'sr',
		'serbian'  => 'sr',
		'sr_rs'    => 'sr',

		// Bulgarian
		'bul'       => 'bg',
		'bulgarian' => 'bg',
		'bg_bg'     => 'bg',

		// Romanian
		'ron'      => 'ro',
		'rum'      => 'ro',
		'romanian' => 'ro',
		'ro_ro'    => 'ro',

		// Hungarian
		'hun'        => 'hu',
		'hungarian'  => 'hu',
		'hu_hu'      => 'hu',

		// Albanian
		'alb'        => 'sq',
		'albanian'   => 'sq',
		'sq_sq'      => 'sq',

		// Arabic
		'ara'        => 'ar',
		'arabic'     => 'ar',
		'ar_sa'      => 'ar',
		'ar_ae'      => 'ar',

		// Azerbaijani
		'aze'        => 'az',
		'azerbaijani'=> 'az',
		'az_az'      => 'az',

		// Belarusian
		'bel'        => 'be',
		'belarusian' => 'be',
		'be_by'      => 'be',

		// Danish
		'dan'        => 'da',
		'danish'     => 'da',
		'da_dk'      => 'da',

		// Greek
		'ell'      => 'el',
		'greek'    => 'el',
		'el_gr'    => 'el',

		// Estonian
		'est'        => 'et',
		'estonian'   => 'et',
		'et_ee'      => 'et',

		// Persian
		'per'        => 'fa',
		'fas'        => 'fa',
		'persian'    => 'fa',
		'fa_ir'      => 'fa',

		// Finnish
		'fin'        => 'fi',
		'finnish'    => 'fi',
		'fi_fi'      => 'fi',

		// Hindi
		'hin'        => 'hi',
		'hindi'      => 'hi',
		'hi_in'      => 'hi',

		// Indonesian
		'ind'        => 'id',
		'indonesian' => 'id',
		'id_id'      => 'id',

		// Japanese
		'jpn'        => 'ja',
		'japanese'   => 'ja',
		'ja_jp'      => 'ja',

		// Dutch
		'dut'        => 'nl',
		'nld'        => 'nl',
		'dutch'      => 'nl',
		'nl_nl'      => 'nl',

		// Slovenian
		'slv'        => 'sl',
		'slovenian'  => 'sl',
		'sl_si'      => 'sl',

		// Swedish
		'swe'        => 'sv',
		'swedish'    => 'sv',
		'sv_se'      => 'sv',

		// Thai
		'tha'        => 'th',
		'thai'       => 'th',
		'th_th'      => 'th',

		// Turkish
		'tur'        => 'tr',
		'turkish'    => 'tr',
		'tr_tr'      => 'tr',

		// Yoruba
		'yor'     => 'yo',
		'yoruba'  => 'yo',
		'yo_ng'   => 'yo',
	],
	
	'url_prefix_map' => [
	  'uk' => 'ua',
	  'sq' => 'al',
	  'el' => 'gr',
	  'cs' => 'cz',
	  'ja' => 'jp',
	  'zh' => 'cn',
	  'he' => 'il',
	  'fa' => 'ir',
	  'ko' => 'kr',
	  'sr' => 'rs',
	],

	'html_lang_map' => [
	  // keep empty by default; users enable only when they need it
	  // 'en' => 'en-GB',
	  // 'pt' => 'pt-BR',
	  // 'zh' => 'zh-Hans',
	],

    // DB tables (without prefix)
    'keys_table'   => 'i18n_keys',
    'values_table' => 'i18n_values',
    'usage_table'  => 'i18n_usage',

    // Cookie + tracking defaults (overridden by system settings)
    'cookie_name'          => 'i18n_mgr',
    'cookie_lifetime_days' => 180,
    'track_usage'          => true,
];
