<?php

use MODX\Revolution\modX;
use MODX\Revolution\modConnectorRequest;

// Ensure MODX core path is available
if (!defined('MODX_CORE_PATH')) {
    require_once dirname(__DIR__, 3) . '/config.core.php';
}

// IMPORTANT: API mode should be defined before MODX is instantiated
if (!defined('MODX_API_MODE')) {
    define('MODX_API_MODE', true);
}

// Load Composer autoloader (MODX 3 relies on it for namespaced classes)
$autoload = MODX_CORE_PATH . 'vendor/autoload.php';
if (file_exists($autoload)) {
    require_once $autoload;
}

// Register i18n PSR-4 autoloader (must be available for processors)
$corePath = MODX_CORE_PATH . 'components/i18n/';
if (file_exists($corePath . 'bootstrap.php')) {
    require_once $corePath . 'bootstrap.php';
}

$modx = new modX();
$modx->initialize('mgr');

// errors service
$modx->getService('error', 'error.modError', '', '');

// minimal logging for connector requests
$modx->setLogLevel(modX::LOG_LEVEL_ERROR);
$modx->setLogTarget('FILE');

// Resolve component paths (allow override)
$componentCorePath = $modx->getOption('i18n.core_path', null, $corePath);
$processorsPath = rtrim($componentCorePath, '/\\') . '/processors/';

// Handle processors via connector request (MODX 3)
$request = new modConnectorRequest($modx);
$request->handleRequest([
    'processors_path' => $processorsPath,
    'location'        => '',
]);
