<?php
/**
 * i18n lexicon (English)
 */

/* ---------------------------------------------------------------------------
 * CMP / Navigation
 * --------------------------------------------------------------------------- */

$_lang['i18n_management'] = 'i18n Manager';
$_lang['i18n_management_desc'] = 'Manage translation keys used across the system.';
$_lang['i18n_tab_keys'] = 'Keys';
$_lang['i18n_tab_import'] = 'Import';
$_lang['i18n_tab_settings'] = 'Settings';

/* ---------------------------------------------------------------------------
 * Keys (grid/actions/columns)
 * --------------------------------------------------------------------------- */

$_lang['i18n_create_key'] = 'Create key';
$_lang['i18n_update_key'] = 'Edit key';
$_lang['i18n_delete_key'] = 'Delete key';
$_lang['i18n_delete_key_confirm'] = 'Delete this key and all its translations?';
$_lang['i18n_delete_selected'] = 'Delete selected';
$_lang['i18n_delete_selected_confirm'] = 'Delete all selected keys and their translations?';

$_lang['i18n_search_key'] = 'Search key…';
$_lang['i18n_filter_group'] = 'Filter by group…';
$_lang['i18n_only_unused'] = 'Only unused';
$_lang['i18n_unlock_renaming'] = 'Unlock renaming';

$_lang['i18n_key'] = 'Key';
$_lang['i18n_group'] = 'Group';
$_lang['i18n_description'] = 'Description';
$_lang['i18n_languages'] = 'Languages';
$_lang['i18n_usage_count'] = 'Usage';
$_lang['i18n_last_used_at'] = 'Last used at';
$_lang['i18n_updated_at'] = 'Updated';

$_lang['i18n_group_regex'] = 'Only Latin letters, numbers and the special character "_"';
$_lang['i18n_group_desc'] = 'If the field is empty, the group specified in the settings will be used';
$_lang['i18n_key_desc'] = 'If empty, a random key will be generated';

/* ---------------------------------------------------------------------------
 * Usage (index / window / actions)
 * --------------------------------------------------------------------------- */

$_lang['i18n_rebuild_usage'] = 'Rebuild usage';
$_lang['i18n_rebuild_usage_confirm'] = 'Recalculate usage statistics?';
$_lang['i18n_usage_show'] = 'Show usage';

$_lang['i18n_usage_title'] = 'Key usage';
$_lang['i18n_usage_loading'] = 'Loading usage data…';
$_lang['i18n_usage_no_key'] = 'No key ID provided.';
$_lang['i18n_usage_empty'] = 'No usage entries found for this key.';
$_lang['i18n_usage_error'] = 'Error while loading usage data.';
$_lang['i18n_usage_context_type'] = 'Context type';
$_lang['i18n_usage_context_name'] = 'Context name';
$_lang['i18n_usage_field'] = 'Field';
$_lang['i18n_usage_context_id'] = 'Context ID';
$_lang['i18n_usage_preview'] = 'Preview';
$_lang['i18n_usage_last_scan_at'] = 'Last scan at';
$_lang['i18n_usage_total'] = 'Total usage:';

/* ---------------------------------------------------------------------------
 * Export
 * --------------------------------------------------------------------------- */

$_lang['i18n_export'] = 'Export';
$_lang['i18n_export_empty'] = 'Nothing to export.';
$_lang['i18n_export_selected_empty'] = 'No selected rows to export.';
$_lang['i18n_export_download_error'] = 'Export completed, but automatic download failed. Please copy the content from the browser console.';
$_lang['i18n_export_error'] = 'Error while exporting keys.';

$_lang['i18n_export_scope'] = 'Scope';
$_lang['i18n_export_scope_selected'] = 'Selected rows';
$_lang['i18n_export_scope_all'] = 'All keys';
$_lang['i18n_export_scope_group'] = 'Group';
$_lang['i18n_export_format'] = 'Format';
$_lang['i18n_export_languages'] = 'Languages';

/* ---------------------------------------------------------------------------
 * Import
 * --------------------------------------------------------------------------- */

$_lang['i18n_import_desc'] = 'Import translation keys and values from JSON or CSV. Preview reads the file and shows summary and detected groups.';
$_lang['i18n_import_file'] = 'File';
$_lang['i18n_import_format'] = 'Format';

$_lang['i18n_import_group_strategy'] = 'Group strategy';
$_lang['i18n_import_group_asis'] = 'Keep as is';
$_lang['i18n_import_group_single'] = 'Use single group';
$_lang['i18n_import_group_custom'] = 'Custom group name';
$_lang['i18n_import_single_group'] = 'Target group';
$_lang['i18n_import_custom_group'] = 'Custom group';

$_lang['i18n_import_langs'] = 'Languages to import';

$_lang['i18n_import_overwrite'] = 'Overwrite rules';
$_lang['i18n_import_overwrite_all'] = 'Overwrite all';
$_lang['i18n_import_overwrite_empty'] = 'Only empty fields';
$_lang['i18n_import_overwrite_skip'] = 'Skip existing';

$_lang['i18n_import_preview'] = 'Preview';
$_lang['i18n_import_preview_title'] = 'Preview';
$_lang['i18n_import_start'] = 'Import';

$_lang['i18n_import_form_not_available'] = 'Import form is not available.';
$_lang['i18n_import_select_file'] = 'Please select a file first.';
$_lang['i18n_import_form_not_found'] = 'Import form not found.';
$_lang['i18n_import_form_not_found_id'] = 'Import form not found.';
$_lang['i18n_preview_failed'] = 'Preview failed.';
$_lang['i18n_browser_read_failed'] = 'Failed to read file in browser.';
$_lang['i18n_running_preview'] = 'Running preview…';
$_lang['i18n_running_import'] = 'Running import…';
$_lang['i18n_import_wait'] = 'Importing translations…';
$_lang['i18n_import_preview_wait'] = 'Preparing preview…';
$_lang['i18n_import_no_preview'] = 'No preview data.';
$_lang['i18n_import_done'] = 'Import completed.';
$_lang['i18n_import_error'] = 'Import failed.';

/* ---------------------------------------------------------------------------
 * Settings
 * --------------------------------------------------------------------------- */

$_lang['i18n_settings_desc'] = 'Configure default language, allowed languages and tracking options.';

$_lang['i18n_default_lang'] = 'Default language';
$_lang['i18n_allowed_langs'] = 'Allowed languages';
$_lang['i18n_allowed_langs_custom'] = 'Custom codes CSV (ISO 3166-1 alpha-2)';
$_lang['i18n_default_prefix'] = 'Default prefix';

$_lang['i18n_cookie_name'] = 'Cookie name';
$_lang['i18n_cookie_lifetime_days'] = 'Cookie lifetime (days)';
$_lang['i18n_mgr_tools_enabled'] = 'Enable floating i18n tools';
$_lang['i18n_route_tools_enabled'] = 'Enable routing i18n tools';
$_lang['i18n_track_usage'] = 'Track usage';

$_lang['i18n_settings_saved'] = 'Settings saved.';
$_lang['i18n_settings_save_error'] = 'Error saving settings.';
$_lang['i18n_settings_load_error'] = 'Error loading settings.';

/* ---------------------------------------------------------------------------
 * Manager floating tools (widget)
 * --------------------------------------------------------------------------- */

$_lang['i18n_copy_key'] = 'Copy key';
$_lang['i18n_copied'] = 'Copied';
$_lang['i18n_inserted_into_field'] = 'Inserted into the last focused field.';
$_lang['i18n_copy_clipboard'] = 'Copied to clipboard (no editable field detected).';
$_lang['i18n_copy_failed'] = 'Copy failed. Please copy manually.';

/* ---------------------------------------------------------------------------
 * Generic / shared errors and statuses
 * --------------------------------------------------------------------------- */

$_lang['i18n_request_failed'] = 'Request failed.';
$_lang['i18n_update_key_invalid_id'] = 'Missing or invalid key ID.';
$_lang['i18n_update_key_load_failed'] = 'Failed to load key data.';
$_lang['i18n_delete_selected_empty'] = 'No keys selected.';
$_lang['i18n_key_updated'] = 'Key updated.';
$_lang['i18n_update_error'] = 'Error while updating key.';

/**
 * Language names
 */
$_lang['i18n_lang_en'] = 'English (en)';
$_lang['i18n_lang_uk'] = 'Ukrainian (uk)';
$_lang['i18n_lang_ru'] = 'Russian (ru)';
$_lang['i18n_lang_pl'] = 'Polish (pl)';
$_lang['i18n_lang_de'] = 'German (de)';
$_lang['i18n_lang_fr'] = 'French (fr)';
$_lang['i18n_lang_es'] = 'Spanish (es)';
$_lang['i18n_lang_it'] = 'Italian (it)';
$_lang['i18n_lang_pt'] = 'Portuguese (pt)';
$_lang['i18n_lang_nl'] = 'Dutch (nl)';
$_lang['i18n_lang_sv'] = 'Swedish (sv)';
$_lang['i18n_lang_no'] = 'Norwegian (no)';
$_lang['i18n_lang_da'] = 'Danish (da)';
$_lang['i18n_lang_fi'] = 'Finnish (fi)';
$_lang['i18n_lang_cs'] = 'Czech (cs)';
$_lang['i18n_lang_sk'] = 'Slovak (sk)';
$_lang['i18n_lang_ro'] = 'Romanian (ro)';
$_lang['i18n_lang_bg'] = 'Bulgarian (bg)';
$_lang['i18n_lang_sr'] = 'Serbian (sr)';
$_lang['i18n_lang_hr'] = 'Croatian (hr)';
$_lang['i18n_lang_lt'] = 'Lithuanian (lt)';
$_lang['i18n_lang_lv'] = 'Latvian (lv)';
$_lang['i18n_lang_et'] = 'Estonian (et)';
$_lang['i18n_lang_hu'] = 'Hungarian (hu)';
$_lang['i18n_lang_tr'] = 'Turkish (tr)';
$_lang['i18n_lang_ar'] = 'Arabic (ar)';
$_lang['i18n_lang_zh'] = 'Chinese Simplified (zh)';
