/**
 * Import tab panel for i18n.
 *
 * @class i18n.panel.Import
 * @extends MODx.Panel
 * @xtype i18n-panel-import
 */

i18n = window.i18n || {};
i18n.panel = i18n.panel || {};

i18n.panel.Import = function (config) {
    config = config || {};

    Ext.applyIf(config, {
        id: 'i18n-panel-import',
        cls: 'container',
        layout: 'fit',
        autoHeight: true,
        items: [{
            xtype: 'panel',
            border: false,
            autoScroll: true,
            bodyStyle: 'padding: 10px;',
            html: '<p>' +
                i18n.lex(
                    'i18n_import_intro',
                    'Import translation keys from a JSON or CSV file exported from this or another project.'
                ) +
                '</p>',
            tbar: [{
                text: i18n.lex('i18n_import_open', 'Import translations…'),
                cls: 'primary-button',
                handler: this.openImportWindow,
                scope: this
            }]
        }]
    });

    i18n.panel.Import.superclass.constructor.call(this, config);
};

Ext.extend(i18n.panel.Import, MODx.Panel, {
    /**
     * Open import window.
     */
    openImportWindow: function () {
        var win = MODx.load({
            xtype: 'i18n-window-import'
        });

        if (win) {
            win.show();
        }
    }
});

Ext.reg('i18n-panel-import', i18n.panel.Import);
