<?php return array (
  'manifest-version' => '1.1',
  'manifest-attributes' => 
  array (
    'license' => '# License Agreement for the Use of the i18n Component
## © Gren Studio. All rights reserved.
## Official website: https://gren.studio  

1. Grant of License
Gren Studio (“Licensor”) hereby grants the purchaser (“Licensee”) a limited, non-exclusive, non-transferable license to use the i18n software component (the “Product”) under the terms of this Agreement. This license is effective only after full payment is received.

2. Permitted Use
The Product may be installed and used on one production domain (e.g. example.com) and any number of associated development or staging environments (e.g. dev.example.com). A separate license is required for each additional production domain.

Use of the Product is permitted only in accordance with its intended functionality and license status. The full functionality is available only after license activation and for the duration of a valid license term.

3. Ownership and Intellectual Property
All rights, title, and interest in and to the Product, including but not limited to the source code, compiled code, documentation, design, and all intellectual property rights, remain the sole and exclusive property of Gren Studio.

This license does not constitute a sale and does not grant ownership or intellectual property rights to the Licensee.

4. Restrictions
The Licensee may not:
- Modify, decompile, disassemble, reverse-engineer, or attempt to access or reconstruct the source code of the Product;
- Resell, sublicense, share, publish, or otherwise distribute the Product or any part of it;
- Remove or obscure any copyright notices or branding included in the Product;
- Circumvent or disable any licensing, authentication, or protection mechanisms.

5. Trial Use
If a trial version of the Product is provided, the Licensee may use it for evaluation purposes only for a limited period (e.g., 14 calendar days). After the trial expires, continued use of the Product requires a valid license. Some features may be disabled or restricted during the trial period.

6. License Activation and Domain Validation
License activation may require online validation against the registered domain name. Gren Studio reserves the right to enforce domain binding, license key validation, and periodic checks to prevent unauthorized use.

7. Termination and Revocation
Gren Studio reserves the right to revoke this license at any time if the Licensee breaches any terms of this Agreement, including unauthorized distribution, modification, or usage beyond the licensed domain.

Upon termination, the Licensee must immediately cease all use of the Product and delete all copies in their possession.

8. Payment and Renewal
The license is valid for the term specified at the time of purchase. Continued use after expiration is allowed only with a valid renewal or new license. Failure to renew constitutes a breach of this Agreement.

9. No Warranty
The Product is provided "as is" without warranty of any kind. Gren Studio shall not be liable for any damages or losses arising from the use or inability to use the Product.',
    'readme' => '# i18n – Multilingual Content Manager for MODX

i18n is a powerful internationalization (i18n) component for MODX Revolution 3. It allows developers and editors to manage translations of site content through unique language keys. Translations are stored in the database and can be retrieved dynamically via snippet calls.

---

## Features

- **Key-based translations**: define a translation key manually or leave it blank for auto-generation; specify a group or use the default one set in System Settings.
- **Dynamic placeholders**: support for placeholder substitution using `{{name}}`, `{{city}}`, etc.
- **Automatic language detection**: via URL prefix, session, or cookie.
- **Language routing plugin**: enables clean `/en/`, `/ru/`, `/de/` prefixes with canonical redirects and fallback to `/`.
- **MODX Manager interface**: visual tabbed UI for editing translation keys and values.
- **Import/export**: manage large translation datasets with CSV or JSON.
- **Usage index tracking**: logs where and when translation keys are used in templates/resources.
- **Floating widget**: quick-access translation key search directly in MODX input fields.
- **Flexible config**: customize languages, key group defaults, fallback behavior, and more.

---

## Requirements

- MODX Revolution 3.x or higher  
- PHP 7.3 or higher  
- **ionCube Loader** v10.2 or higher (**required**)
- **libsodium PHP extension** (ext-sodium) (**required**)
- MySQL or compatible database  
- Apache/Nginx with `friendly_urls` enabled  
- .htaccess file in place (`ht.access` → `.htaccess` in site root)

> ⚠️ Without ionCube Loader, the module will not function.

---

## Installation

1. Download the i18n package (ZIP) from Gren Studio, ModStore, CodeCanyon, or GitHub.  
2. In MODX Manager: go to **Package Management → Add New Package**, upload ZIP and install.  
3. Ensure `friendly_urls = true` is enabled in System Settings.  
4. Rename `ht.access` to `.htaccess` in your site root if needed.  
5. Enable the **i18nLangRoute** plugin for automatic language routing.  
6. (Optional) Disable the language route plugin or Manager widget via System Settings.  
7. Activate your license key via **Extras → i18n** in MODX Manager.

---

## Usage

- **Output current language**:  
  ```
  [[!i18nGetLang]]
  ```

- **Basic translation call**:  
  ```
  [[!i18nKey? &key=`site.title`]]
  ```

- **With placeholders**:  
  ```
  [[!i18nKey? &key=`greeting` &placeholders=`{"name":"John"}`]]
  ```  
  Translation string: `Hello, my name {{name}} and it\'s a test message.`  
  Output: `Hello, my name John and it\'s a test message.`

- **Force specific language**:  
  ```
  [[!i18nKey? &key=`site.title` &lang=`en`]]
  ```

- **Auto-detect language with routing**:  
  ```
  [[!i18nKey? &key=`site.title` &lang=`[[!i18nGetLang]]`]]
  ```

---

## Key Management Features

- Keys and groups can be set manually or generated automatically.
- When a key or group is renamed, all usage references are automatically updated across content and templates to reduce maintenance overhead.

---

## License & Purchase

This component is distributed under a commercial license. You may use i18n on **one production domain** per license. Redistribution, code modification, or public publication is prohibited.

- Includes 1 year of updates and support.  
- Read full terms in the LICENSE file.

Purchase at: [https://gren.studio](https://gren.studio)

---

## Support

- Website: https://gren.studio  
- Email: info@gren.studio  
- GitHub Issues: https://github.com/RedFall/i18n

---

## Demo & Promotion

Want to test i18n before buying? Request a trial license on our website.  
Launch a multilingual MODX site in minutes — no context duplication, no Babel overhead.

---

© Gren Studio. All rights reserved.',
    'changelog' => '1.1.7 (pl)
----------
- Initial public build for MODX 3.',
    'requirements' => '## Requirements

- MODX Revolution 3.x or higher  
- PHP 7.3 or higher  
- **ionCube Loader** v10.2 or higher (**required**)  
- MySQL or compatible database  
- Apache/Nginx with `friendly_urls` enabled  
- .htaccess file in place (`ht.access` → `.htaccess` in site root)',
  ),
  'manifest-vehicles' => 
  array (
    0 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modNamespace',
      'guid' => 'eab03fb1a2b2176469f276ab959eb53b',
      'native_key' => 'i18n',
      'filename' => 'MODX/Revolution/modNamespace/f05f263f03acd6f72ade8b386ae23b1b.vehicle',
      'namespace' => 'i18n',
    ),
    1 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modNamespace',
      'guid' => '52e423d5fee9fdc96b1ac0573854d270',
      'native_key' => 'i18n',
      'filename' => 'MODX/Revolution/modNamespace/5c84d3cecf4631e4cdbd1da5ccc56266.vehicle',
      'namespace' => 'i18n',
    ),
    2 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modSystemSetting',
      'guid' => '7551c8b83e3d1451305ea840c9b43f48',
      'native_key' => 'i18n._install_signature',
      'filename' => 'MODX/Revolution/modSystemSetting/1bf8c1edb88ee3e4b477eb8dff5c225d.vehicle',
      'namespace' => 'i18n',
    ),
    3 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modSystemSetting',
      'guid' => 'f9b48e7417758439152d1513533499c8',
      'native_key' => 'i18n.default_lang',
      'filename' => 'MODX/Revolution/modSystemSetting/6050fdd542e1f23695dee3e03f157b69.vehicle',
      'namespace' => 'i18n',
    ),
    4 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modSystemSetting',
      'guid' => '17a89731e02627edc0a54ef2d16b1d42',
      'native_key' => 'i18n.allowed_langs',
      'filename' => 'MODX/Revolution/modSystemSetting/6eb848cae384270f143aa6b337ab197d.vehicle',
      'namespace' => 'i18n',
    ),
    5 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modSystemSetting',
      'guid' => '661097a905d1ea12b4db0f248e851d07',
      'native_key' => 'i18n.default_prefix',
      'filename' => 'MODX/Revolution/modSystemSetting/3128789c7dac6e8f4359d99d7e28d861.vehicle',
      'namespace' => 'i18n',
    ),
    6 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modSystemSetting',
      'guid' => 'b9d81aceed69d98b0e4fe91f2e022bd6',
      'native_key' => 'i18n.cookie_lifetime_days',
      'filename' => 'MODX/Revolution/modSystemSetting/1bd442d431e692ceee8a1665260ca364.vehicle',
      'namespace' => 'i18n',
    ),
    7 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modSystemSetting',
      'guid' => '11df0bf55004c3ea2007c71c20e91cd2',
      'native_key' => 'i18n.cookie_name',
      'filename' => 'MODX/Revolution/modSystemSetting/d545417406ac8c855d446e9d4df39342.vehicle',
      'namespace' => 'i18n',
    ),
    8 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modSystemSetting',
      'guid' => '0f7c0b31826b773c89e971853ec10db4',
      'native_key' => 'i18n.mgr_tools_enabled',
      'filename' => 'MODX/Revolution/modSystemSetting/ee3f252991e7d874c4567fb4d276612a.vehicle',
      'namespace' => 'i18n',
    ),
    9 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modSystemSetting',
      'guid' => 'bb65e4938e360d6c4a55e93223f21eeb',
      'native_key' => 'i18n.route_tools_enabled',
      'filename' => 'MODX/Revolution/modSystemSetting/4c9933ae4e16da81e80fe7f1cecd28a6.vehicle',
      'namespace' => 'i18n',
    ),
    10 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modSystemSetting',
      'guid' => '48dbc087abcd438ea384f697d56e19d9',
      'native_key' => 'i18n.track_usage',
      'filename' => 'MODX/Revolution/modSystemSetting/5329e998bc5c4bc14e823dd37d8b1300.vehicle',
      'namespace' => 'i18n',
    ),
    11 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modSystemSetting',
      'guid' => '1a90b276635595c6762166cd32bc253a',
      'native_key' => 'i18n.license_endpoint',
      'filename' => 'MODX/Revolution/modSystemSetting/723988d1b1f5c01ad1c37145a706e5d2.vehicle',
      'namespace' => 'i18n',
    ),
    12 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modSystemSetting',
      'guid' => 'c554a9efff82aa268d8b133b3b80b680',
      'native_key' => 'i18n.license_token',
      'filename' => 'MODX/Revolution/modSystemSetting/5cdc8799bd634dbf2f94897b3730e1bb.vehicle',
      'namespace' => 'i18n',
    ),
    13 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modSystemSetting',
      'guid' => '9a55c551ff37cf82d2965783c9ea6f38',
      'native_key' => 'i18n.license_server_pubkey_b64',
      'filename' => 'MODX/Revolution/modSystemSetting/3db8a978b5ca048da0e02dbc51651d27.vehicle',
      'namespace' => 'i18n',
    ),
    14 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modSystemSetting',
      'guid' => '42980f3afefe82dfa9d860786cd782aa',
      'native_key' => 'i18n.license_payload',
      'filename' => 'MODX/Revolution/modSystemSetting/1baf2bacb2481ff1b50a3f24193d2e94.vehicle',
      'namespace' => 'i18n',
    ),
    15 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modSystemSetting',
      'guid' => '7ab2b643c0cca13c80140b53b4e4e96f',
      'native_key' => 'i18n.license_state',
      'filename' => 'MODX/Revolution/modSystemSetting/218130e73848b2ea7716342fb5e335c5.vehicle',
      'namespace' => 'i18n',
    ),
    16 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modSystemSetting',
      'guid' => '5a90c1f0e99581df773e0bdf4e816ee2',
      'native_key' => 'i18n.license_checkin_interval',
      'filename' => 'MODX/Revolution/modSystemSetting/26ad1dfa60ba90307f6224986017c4a3.vehicle',
      'namespace' => 'i18n',
    ),
    17 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modSystemSetting',
      'guid' => 'cedbedb52028ac7cbba51846759df3e7',
      'native_key' => 'i18n.license_checkin_min_interval',
      'filename' => 'MODX/Revolution/modSystemSetting/d468f163d4a34ff4699d1ac760c3f6f5.vehicle',
      'namespace' => 'i18n',
    ),
    18 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modCategory',
      'guid' => 'ee4e0841c874f5c93265b8443ddf8a04',
      'native_key' => NULL,
      'filename' => 'MODX/Revolution/modCategory/3c48f8cf3afe2bfe55992eb045efad1d.vehicle',
      'namespace' => 'i18n',
    ),
    19 => 
    array (
      'vehicle_package' => '',
      'vehicle_class' => 'xPDO\\Transport\\xPDOObjectVehicle',
      'class' => 'MODX\\Revolution\\modMenu',
      'guid' => '10dc02e9eb19b451132fc964eca87c9c',
      'native_key' => 'i18n',
      'filename' => 'MODX/Revolution/modMenu/0f3084c54cb747a782a25df300ca8334.vehicle',
      'namespace' => 'i18n',
    ),
  ),
);